unit XBBDemo2;

{
  Property entry for the XML Building Blocks demonstration.

  Written by Keith Wood (kbwood@iprimus.com.au)
  7 March 2002.
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, ExtCtrls, DBTables, XMLBlocks;

type
  TfrmProperties = class(TForm)
    pnlCommon: TPanel;
      Label7: TLabel;
      edtTagName: TEdit;
    pnlSQL: TPanel;
      Label4: TLabel;
      edtRecordTag: TEdit;
      Label1: TLabel;
      cmbDatabase: TComboBox;
      Label2: TLabel;
      memSQL: TMemo;
      Label6: TLabel;
      ragFormat: TRadioGroup;
    pnlComponent: TPanel;
      Label5: TLabel;
      cmbComponent: TComboBox;
    pnlTimestamp: TPanel;
      Label3: TLabel;
      edtFormat: TEdit;
      chkAtStart: TCheckBox;
    pnlButtons: TPanel;
      btnOK: TBitBtn;
      btnCancel: TBitBtn;
  private
  public
    constructor Create(AOwner: TComponent); override;
    procedure ComponentProperties(var TagName, ComponentName: string);
    procedure SimpleProperties(var TagName: string);
    procedure SQLProperties(
      var TagName, RecordTagName, DatabaseName, SQL: string;
      var Format: TXBBFieldFormat);
    procedure TimestampProperties(var TagName, Format: string;
      var InsertAtStart: Boolean);
  end;

implementation

{$R *.dfm}

{ Initialise with components and databases }
constructor TfrmProperties.Create(AOwner: TComponent);
var
  Index: Integer;
  Values: TStringList;
begin
  inherited Create(AOwner);
  for Index := 0 to AOwner.ComponentCount - 1 do
    if AOwner.Components[Index].Name <> Name then
      cmbComponent.Items.Add(AOwner.Components[Index].Name);
  Values := TStringList.Create;
  try
    Session.GetDatabaseNames(Values);
    for Index := 0 to Values.Count - 1 do
      cmbDatabase.Items.Add(Values[Index]);
  finally
    Values.Free;
  end;
end;

{ Ask for properties of TXBBComponent }
procedure TfrmProperties.ComponentProperties(var TagName, ComponentName: string);
begin
  pnlSQL.Visible         := False;
  pnlComponent.Visible   := True;
  pnlTimestamp.Visible   := False;
  edtTagName.Text        := TagName;
  cmbComponent.ItemIndex := cmbComponent.Items.IndexOf(ComponentName);
  ClientHeight           := pnlButtons.Top + pnlButtons.Height;
  if ShowModal <> mrOK then
    Exit;
  TagName       := edtTagName.Text;
  ComponentName := cmbComponent.Items[cmbComponent.ItemIndex];
end;

{ Ask for properties of other TXMLBuildingBlocks }
procedure TfrmProperties.SimpleProperties(var TagName: string);
begin
  pnlSQL.Visible       := False;
  pnlComponent.Visible := False;
  pnlTimestamp.Visible := False;
  edtTagName.Text      := TagName;
  ClientHeight         := pnlButtons.Top + pnlButtons.Height;
  if ShowModal <> mrOK then
    Exit;
  TagName := edtTagName.Text;
end;

{ Ask for properties of TXBBSQL }
procedure TfrmProperties.SQLProperties(
  var TagName, RecordTagName, DatabaseName, SQL: string;
  var Format: TXBBFieldFormat);
begin
  pnlSQL.Visible        := True;
  pnlComponent.Visible  := False;
  pnlTimestamp.Visible  := False;
  edtTagName.Text       := TagName;
  edtRecordTag.Text     := RecordTagName;
  cmbDatabase.ItemIndex := cmbDatabase.Items.IndexOf(DatabaseName);
  memSQL.Lines.Text     := SQL;
  ragFormat.ItemIndex   := Ord(Format);
  ClientHeight          := pnlButtons.Top + pnlButtons.Height;
  if ShowModal <> mrOK then
    Exit;
  TagName       := edtTagName.Text;
  RecordTagName := edtRecordTag.Text;
  DatabaseName  := cmbDatabase.Items[cmbDatabase.ItemIndex];
  SQL           := memSQL.Lines.Text;
  Format        := TXBBFieldFormat(ragFormat.ItemIndex);
end;

{ Ask for properties of TXBBTimestamp }
procedure TfrmProperties.TimestampProperties(var TagName, Format: string;
  var InsertAtStart: Boolean);
begin
  pnlSQL.Visible       := False;
  pnlComponent.Visible := False;
  pnlTimestamp.Visible := True;
  edtTagName.Text      := TagName;
  edtFormat.Text       := Format;
  chkAtStart.Checked   := InsertAtStart;
  ClientHeight         := pnlButtons.Top + pnlButtons.Height;
  if ShowModal <> mrOK then
    Exit;
  TagName       := edtTagName.Text;
  Format        := edtFormat.Text;
  InsertAtStart := chkAtStart.Checked;
end;

end.
